<?php
/**
 * Uninstall script for Campaigns Lite for Laposta
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('campaigns_lite_for_laposta_api_key');

// Delete transient tracking option
$campaigns_lite_transient_keys = get_option('campaigns_lite_for_laposta_transient_keys', array());
if (!empty($campaigns_lite_transient_keys)) {
    foreach ($campaigns_lite_transient_keys as $campaigns_lite_key) {
        delete_transient($campaigns_lite_key);
    }
}
delete_option('campaigns_lite_for_laposta_transient_keys');

// Delete any cached transients that might have been missed
global $wpdb;
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
        $wpdb->esc_like('_transient_campaigns_lite_for_laposta_') . '%',
        $wpdb->esc_like('_transient_timeout_campaigns_lite_for_laposta_') . '%'
    )
);