<?php
/**
 * Main Laposta Campaigns Class
 *
 * @package Campaigns_Lite_For_Laposta
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Main plugin class
 */
class Campaigns_Lite_For_Laposta {
    /**
     * Plugin instance.
     *
     * @var Campaigns_Lite_For_Laposta
     */
    private static $instance = null;

    /**
     * The API instance.
     *
     * @var Campaigns_Lite_For_Laposta_API
     */
    private $api;

    /**
     * The settings instance.
     *
     * @var Campaigns_Lite_For_Laposta_Settings
     */
    private $settings;

    /**
     * Constructor.
     */
    public function __construct() {
        $this->load_dependencies();
        $this->init();
    }

    /**
     * Get plugin instance.
     *
     * @return Campaigns_Lite_For_Laposta
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Load required dependencies
     */
    private function load_dependencies() {
        // Load API class
        require_once CAMPAIGNS_LITE_FOR_LAPOSTA_PLUGIN_DIR . 'includes/class-campaigns-lite-for-laposta-api.php';
        $this->api = new Campaigns_Lite_For_Laposta_API();

        // Load settings class if in admin area
        if (is_admin()) {
            require_once CAMPAIGNS_LITE_FOR_LAPOSTA_PLUGIN_DIR . 'includes/class-campaigns-lite-for-laposta-settings.php';
            $this->settings = new Campaigns_Lite_For_Laposta_Settings();
        }
    }

    /**
     * Initialize plugin features
     */
    private function init() {
        // Add any initialization code here
        add_action('init', array($this, 'init_hooks'));
    }

    /**
     * Initialize WordPress hooks
     */
    public function init_hooks() {
        // Add any frontend hooks here
    }

    /**
     * Get the API instance
     *
     * @return Campaigns_Lite_For_Laposta_API
     */
    public function get_api() {
        return $this->api;
    }

    /**
     * Get the settings instance
     *
     * @return Campaigns_Lite_For_Laposta_Settings
     */
    public function get_settings() {
        return $this->settings;
    }
}