jQuery(document).ready(function($) {
  // API Key Toggle - Toggle between password and text input types
  $(document).on('click', '.toggle-api-key', function() {
    var $button = $(this);
    var $input = $button.siblings('input');
    var showText = $button.data('show');
    var hideText = $button.data('hide');

    if ($input.attr('type') === 'password') {
      $input.attr('type', 'text');
      $button.text(hideText);
    } else {
      $input.attr('type', 'password');
      $button.text(showText);
    }
  });

  // Account number copy
  $(document).on("click", "#copy-account-number", function (e) {
      e.preventDefault();
      var $copyButton = $(this);
      var accountNumber = $copyButton.data("account-number");

      if (navigator.clipboard) {
        navigator.clipboard
          .writeText(accountNumber)
          .then(function () {
            $copyButton
              .text(campaignsLiteForLaposta.copied)
              .prop("disabled", true);
            setTimeout(function () {
              $copyButton
                .text(campaignsLiteForLaposta.copy_to_clipboard)
                .prop("disabled", false);
            }, 2000);
          })
          .catch(function (err) {
            console.error("Could not copy text: ", err);
          });
      } else {
        // Fallback for browsers that don't support clipboard API
        var tempInput = $("<input>");
        $("body").append(tempInput);
        tempInput.val(accountNumber).select();
        document.execCommand("copy");
        tempInput.remove();

        $copyButton.text(campaignsLiteForLaposta.copied).prop("disabled", true);
        setTimeout(function () {
          $copyButton.text(campaignsLiteForLaposta.copy_to_clipboard).prop("disabled", false);
        }, 2000);
      }
  });
  
  // Remove the per-campaign fetch button functionality
  
  // Clear campaign cache button (for admins)
  $(document).on('click', '#clear-campaign-cache', function(e) {
      e.preventDefault();
      var $button = $(this);
      
      $button.prop('disabled', true).text(campaignsLiteForLaposta.clearing || 'Clearing...');
      
      // Make an AJAX request to clear cache
      $.ajax({
          url: campaignsLiteForLaposta.ajaxurl,
          type: 'POST',
          data: {
              action: 'campaigns_lite_for_laposta_clear_campaign_cache',
              nonce: campaignsLiteForLaposta.nonce
          },
          success: function(response) {
              if (response.success) {
                  $button.text(response.data && response.data.message ? response.data.message : 'Cleared!');
                  setTimeout(function() {
                      location.reload();
                  }, 1000);
              } else {
                  $button.text(response.data && response.data.message ? response.data.message : 'Error').addClass('button-secondary');
                  setTimeout(function() {
                      $button.prop('disabled', false).text('Retry').removeClass('button-secondary');
                  }, 2000);
              }
          },
          error: function(jqXHR, textStatus, errorThrown) {
              console.error('AJAX Error:', textStatus, errorThrown);
              $button.text('Failed: ' + textStatus).addClass('button-secondary');
              setTimeout(function() {
                  $button.prop('disabled', false).text('Retry').removeClass('button-secondary');
              }, 2000);
          }
      });
  });
  
  // No refresh all button needed anymore since Clear Cache is sufficient
});